<?php
/**
 * ODTLib in one solid file!
 *
 * This is a generated Text, please do not edit any thing in this file! Use the
 * non solid files instead!
 *
 *  
 *
 * $Id: aaasingleFile.txt,v 1.1 2006/09/17 18:08:59 Andi Exp $
 *
 * @license   GNU Lesser General Public License
 * @copyright Copyright &copy; 2006, Andi Hotz
 * @author    Andi Hotz
 * @version   $Revision: 1.1 $
 * @package   OpenDocument
 * 
 * @since 0.0.1
 */
 include 'pclzip.lib.php';
 ?><?php

/**
 * The DAO interface defines the method
 * that must be provided by an implementation
 * so that an OpenDocument Text Template can
 * be completed with data from a datasource
 * (mainly database, but HTML forms should
 * also be a possibility)
 * 
 * $Id: DAO.interface.php,v 1.2 2006/09/17 17:29:24 Andi Exp $
 *
 * @license    http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @copyright  Copyright in 2006 by Andi Hotz
 * @copyright  GNU Lesser General Public License
 * @author     Andi Hotz
 * @version    $Revision: 1.2 $
 * @package    ODFLib
 * @since      0.0.1
 */
interface DAO{
	
}
?><?php


/**
 * The IO class handles the extraction of the
 * content.xml from the zipped *.odt file and
 * writting it back later on.
 *  
 * $Id: IO.class.php,v 1.2 2006/09/18 18:51:18 Andi Exp $
 *
 * @license    http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @copyright  Copyright in 2006 by Andi Hotz
 * @copyright  GNU Lesser General Public License
 * @author     Andi Hotz
 * @version    $Revision: 1.2 $
 * @package    ODFLib
 * @since      0.0.1
 */
class IO {
	
    /**
     * Filename of the archive
     */
	private $archiveName;
	/**
	 * Name of the document without ending (.odt)
	 */
	private $filename;
	/**
	 * Ending of the document (.odt)
	 */
	private $fileending;
	/**
	 * Name of the xml file in the achive (content.xml)
	 */
	private $xmlfile;
	/**
	 * Path to $xmlfile in the archive
	 */
	private $xmldir;
	/**
	 * Contents of the xml file
	 */
	private $xmlcontents;
	/**
	 * Path for preview and XML contents
	 */
	private $tmpdir;
	/**
	 * Output directory for documents
	 */
	private $outputdir;
	
	/**
	 * Initialise some member variables
	 * @param name of the archive
	 */
	public function __construct($aName){
		$this->archiveName=$aName;
		$dsep = DIRECTORY_SEPARATOR;
		$scriptPath = dirname($_SERVER["SCRIPT_FILENAME"]);
		$this->outputdir = $scriptPath.$dsep.'output'.$dsep;
		
		if (!($this->outputdir = $this->checkPath($this->outputdir))) throw new Exception("Kein temporäres Verzeichnis angegeben!", 10);
		// add a slash to the directory
		if (!preg_match('/\/$/', $this->outputdir)) $this->outputdir .= '/';
		$this->tmpdir = $this->outputdir;
		// if not available make a new directory in the filesystem
		if (!is_dir($this->tmpdir)) mkdir($this->tmpdir);
	}
	
	/**
	 * Open an Archive and extract the file $fileName
	 * as a string
	 * @param  $fileName file to extract from the archive
	 * @return String with the content of $fileName
	 * @throws Exception if an error occured while opening the archive
	 */
	protected function openArchive($fileName){
		// TODO: Refactoring to work with zip from the php framework
		preg_match('/(.+)\.(\w{3,4})$/', $fileName, $_tmp);
	    $this->filename = $_tmp[1];
	    $this->fileending = $_tmp[2];
   		$this->xmlfile = $fileName;
   		$this->xmldir = '';
	    //require_once('pclzip.lib.php');
		$archiv = new PclZip($this->archiveName);
		$result = $archiv->extract(PCLZIP_OPT_BY_NAME,$fileName,PCLZIP_OPT_EXTRACT_AS_STRING);
		if ($result==0) throw new Exception("Problems while unzipping:".$archiv->errorInfo(true),10);
		return $result[0]['content'];
	}
	
	/**
	 * Extracts the content.xml file from an archive
	 * @return content.xml as string
	 * @throws Exception if an error occured while opening the archive
	 * @see openArchive($archiveName, $fileName)
	 */
	public function getContent(){
		return $this->openArchive('content.xml');
	}
	
	/**
	 * Extracts the content.xml file from an archive
	 * @return styles.xml as string
	 * @throws Exception if an error occured while opening the archive
	 * @see openArchive($archiveName, $fileName)
	 */
	public function getStyle(){
		return $this->openArchive('styles.xml');
	}
	
	/**
	 * Save the content of a file into the archive
	 * @param $fileName file name in the archive
	 * @param $fileContents file as string
	 * @throws Exception if the file cannot be added or the
	 * duplicate cannot be removed
	 */
	public function saveArchive($fileName,$fileContents) {
		if (!is_dir($this->outputdir)) mkdir($this->outputdir);
	 	$archiveName_new = $this->outputdir.$this->archiveName;
	 	copy($this->archiveName,$archiveName_new);
	 	$zip = new ZipArchive;
		$res = $zip->open($archiveName_new);
		if ($res === TRUE) {
		   $zip->addFromString($fileName, $fileContents);
		   $zip->close();
		} else {
		   throw new Exception("Error: File could not be added to archive.");
		}
		/*
	 	$this->copyFile($this->archiveName,$archiveName_new);
	 	//copy($this->archiveName,$archiveName_new);
	 	file_put_contents($fileName,$fileContents);
	 	$archive = new PclZip($archiveName_new);
	 	if ($archive->delete(PCLZIP_OPT_BY_NAME,dirname($fileName).'/'.$fileName)==0){
	 		throw new Exception("Error: ".$archive->errorInfo(true));
	 	}
	 	if ($archive->add($fileName,PCLZIP_OPT_ADD_PATH,dirname($fileName))==0){
	 		throw new Exception("Error: ".$archive->errorInfo(true));
	 	}*/
	 }

	 /**
	 * Save the content of a file into the archive
	 * @param string $fileContents changed contents of the xml file
	 * @throws Exception if the file cannot be added or the
	 * duplicate cannot be removed
	 */
	 public function saveFile($fileContents) {
	      $this->xmlcontents=$fileContents;
		  if (!($this->tmpdir && $this->outputdir && $this->filename && $this->fileending && $this->xmlfile && $this->xmlcontents)) throw new Exception("Missing outputdir, filename oder filecontents", 65);
		  if (!file_put_contents($this->tmpdir . $this->xmlfile, $this->xmlcontents)) throw new Exception("Temp XML file could not be written", 66);
		  $_h = getDate();
		  $_erweiterung = sprintf("_%4d-%02d-%02d_%02d-%02d-%02d_", $_h['year'], $_h['mday'], $_h['mon'], $_h['hours'], $_h['minutes'], $_h['seconds']);
		  $_name_neu = $this->outputdir . $this->filename . $_erweiterung;
		  $_index = 1;
		  while (is_file($_name_neu . $_index . '.' . $this->fileending)) ++$_index;
		  $_name_neu .= $_index . '.' . $this->fileending;
		  // copy of the file
		  $this->copyFile($this->filename . '.' . $this->fileending, $_name_neu);
		  //require_once('pclzip.lib.php');
		  $archiv = new PclZip($_name_neu);
		  // delete old version of file from archive
		  if ($archiv->delete(PCLZIP_OPT_BY_NAME,$this->xmlfile)==0) throw new Exception("Error on deleting from ZIP archive: " . $archiv->errorInfo(true));
		  // copy changed file from tempdir into archive
		  if ($archiv->add($this->tmpdir . $this->xmlfile, PCLZIP_OPT_REMOVE_PATH, $this->tmpdir, PCLZIP_OPT_ADD_PATH, $this->xmldir) == 0) throw new Exception("Error on writing ZIP archive: " . $archiv->errorInfo(true));
		  return($_name_neu);
	 }

 	  /**
 	   * Check if a path is valid e.g. path doesn't point to system
 	   * files.
 	   * @param string $_path path to be checked
 	   * @return true if path is valid
 	   * @throws $_path is not a valid argument
 	   */
	  protected function checkPath($_path) {
  		  if (!$_path) return false;
  		  // Change backslashes to slashes
  		  $_path = str_replace(array('\\','/'), '/', $_path);
  		  if (preg_match('/\.\.\//', $_path) || preg_match('/^\//', $_path)) throw new Exception("Argument $_path contains non valid path", 30);
  		  if (!preg_match('/\w/', $_path)) return false;
  		 return $_path;
 	  }

 	  /**
 	   * Copy a file
 	   * @param string $_filename path of source file
 	   * @param string $_filename_new path of destination file
 	   * @throws Copying failed
 	   */
   	  protected function copyFile($_filename, $_filename_new) {
  		  foreach (array($_filename, $_filename_new) as $_path) $this->checkPath($_path);
echo "copy from ".$_filename." to ". $_filename_new."<br/>";
  		  if (!copy($_filename, $_filename_new)) throw new Exception("Copiing of file $_filename to $_filename_new failed", 70);
 	  }

	 // Hilfsfunktion: Liest Dokument aus Zip-Archiv
	 // 1. Parameter: Archivname
	 // 2. Parameter: auszulesendes Dokument
	 // 3. Parameter: Verzeichnis, in welches das Dokument geschrieben wird;
	 // ist der 3. Parameter leer, gibt die Funktion nur den Dateiinhalt zurück
	 // nutzt: $this->checkPath() und PclZip
	 public function oeffnen($_archivname, $_filename/*, $_schreibpfad*/) {
		// TODO: Refactoring to work with zip from the php framework
	 	preg_match('/(.+)\.(\w{3,4})$/', $_archivname, $_tmp);
	    $this->filename = $_tmp[1];
	    $this->fileending = $_tmp[2];
   		$this->xmlfile = $_filename;
   		$this->xmldir = '';
	 	foreach (array($_archivname, $_filename) as $_para) {
	   $_path = $this->checkPath($_para);
	   if (!$_para) throw new Exception("Archive missing", 20);
	  }
	  //$_schreibpfad = $this->checkPath($_schreibpfad);
	  if (!file_exists($_archivname)) throw new Exception("$_archivname could not be found", 21);
	  // bindet PclZip ein
	  //require_once('pclzip.lib.php');
	  $archiv = new PclZip($_archivname);
	  // kein Schreibpfad -> Dokument in String entpacken
	  //if (!$_schreibpfad) {
	   $_ret = $archiv->extract(PCLZIP_OPT_BY_NAME, $_filename, PCLZIP_OPT_EXTRACT_AS_STRING);
	  // ansonsten Pfad der zu extrahierenden Datei vom Dateinamen abtrennen
	  /*} else {
	   preg_match('/^(.+)\/(.+)$/', $_filename, $_archivpfad);
	   // Doubletten löschen - PclZip überschreibt Dateien nicht zuverlässig
	   if (file_exists($_schreibpfad . $_archivpfad[2])) unlink($_schreibpfad . $_archivpfad[2]);
	   // in Datei entpacken
	   $_ret = $archiv->extract(PCLZIP_OPT_BY_NAME, $_filename, PCLZIP_OPT_PATH, $_schreibpfad, PCLZIP_OPT_REMOVE_PATH, $_archivpfad[1]);
	  }*/
	  // Rückgabewert 0 = Fehler
	  if ($_ret == 0) throw new Exception("Problems while unzipping: " . $archiv->errorInfo(true), 22);
	  // gibt den Dateinamen zurück, falls eine Datei geschrieben wurde,
	  // ansonsten den Inhalt
	  // $_ret[0] ist ein benannter Array, der das gezippte Dokument enthält
	  return /*$_schreibpfad? $_ret[0]['filename'] :*/ $_ret[0]['content'];
	 } 	  
}
?><?php

/**
 * The Replace class handles the replacement
 * of Strings that can be defined in the contetnt.xml
 * file. Specific functions provide replacement for
 * specific HTML tags.
 *  
 * $Id: Replace.class.php,v 1.1.1.1 2006/09/17 15:41:38 Andi Exp $
 *
 * @license    http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @copyright  Copyright in 2006 by Andi Hotz
 * @copyright  GNU Lesser General Public License
 * @author     Andi Hotz
 * @version    $Revision: 1.1.1.1 $
 * @package    ODFLib
 * @since      0.0.1
 */
class Replace{

  /**
   * namespace OpenDocument text
   */
	const TEXT = 'urn:oasis:names:tc:opendocument:xmlns:text:1.0';  
        
	/**
	 * DomDocument representation of an XML file
	 *
	 * @var DOMDocument
	 */
	private $dom ;
	
	/**
	 * Current node in den DOMDocument
	 */
	private $currentNode;
	
	/**
	 * Constructor initialises DOM structure with
	 * $xmlFileContents. The current node is initialised
	 * with the body tag.
	 * @param string $xmlFileContets XML file in a string representation.
	 */
	public function __construct($xmlFileContets){
		$this->dom = new DOMDocument;
		$this->dom->loadXML($xmlFileContets);
		$domList=$this->dom->getElementsByTagName('body');
		$this->currentNode=new DOMNode();
		$this->currentNode=$domList->item(0);
	}
	
	/**
	 * Walk through all paragraphs ('p' tag) of
	 * the DOMDocument untill the first is found
	 * that first child contains the replace string.
	 * The currentNode pointer is set to the parent node
	 * of the text node.
	 * @param string $replace
	 * @throws template string could not be found
	 */
	private function findString($replace){
	    //require_once('odfNodes/Paragraph.class.php');
		$tags = $this->dom->getElementsByTagNameNS(self::TEXT ,'p');
		$i=0;
		while ($field = $tags->item($i)){
			if ($field->firstChild && $field->nodeValue == $replace){
				$this->currentNode=$field;
				return;
			} else {
				$i++;
			}
		}
		throw new Exception("The template string ".$replace." could not be found.");
	}
	
	/**
	 * The replace string is thought in the the document
	 * by use of methode findString(string). The replace string
	 * is replaced by the replacement string
	 *
	 * @param string $replace should be replaced
	 * @param string $replacement replaces $replace
	 */
	public function replaceText($replace,$replacement){
		$this->findString($replace);
		$textNode = $this->dom->createTextNode($replacement);
		$this->currentNode->replaceChild($textNode,$this->currentNode->firstChild);
	}
	
	/**
	 * Add a new paragraph at the position of currentNode
	 * @param  string $paragraphText text of the new paragraph
	 */
	public function addParagraph($paragraphText){
		//require_once('odfNodes/Paragraph.class.php');
		$paragraph = new Paragraph($this->dom);
		$paragraph->addParagraph($paragraphText,$this->currentNode);
		$this->procedeNext();
	}
	/**
	 * Add a new paragraph at the position of currentNode
	 * @param  string $paragraphText text of the new paragraph
	 * @param string $style style of the paragraph
	 */
	public function addStyledParagraph($paragraphText,$style){
		//require_once('odfNodes/Paragraph.class.php');
		$paragraph = new Paragraph($this->dom);
		$paragraph->addStyledParagraph($paragraphText,$this->currentNode,$style);
		$this->procedeNext();
	}
	
	/**
	 * Remove the Text replace. The tag is not removed.
	 * @param string $replace Template-String
	 */
	public function removeReplaceString($replace){
		$this->findString($replace);
		$node = $this->currentNode;
		$node->removeChild($this->currentNode->firstChild);
	}
	
	/**
	 * Remove the previous sibling of the current node
	 */
	public function removePreviousSibling(){
		$prev = $this->currentNode->previousSibling;
		$this->currentNode->removeChild($prev);
	}

	/**
	 * Add a new paragraph at the position of currentNode
	 * @param  string $paragraphText text of the new heading
	 * @param int $level of the Heading
	 */
	public function addHeadding($head,$level){
		//require_once('odfNodes/Heading.class.php');
		$paragraph = new Heading($this->dom);
		$paragraph->addHeading($head,$level,$this->currentNode);
		$this->procedeNext();
	}
	/**
	 * Add a new paragraph at the position of currentNode
	 * @param  string $paragraphText text of the new heading
	 * @param int $level of the Heading
	 * @param string $style style of the paragraph
	 */
	public function addStyledHeading($paragraphText,$level,$style){
		//require_once('odfNodes/Heading.class.php');
		$paragraph = new Heading($this->dom);
		$paragraph->addStyledHeading($paragraphText,$level,$this->currentNode,$style);
		$this->procedeNext();
	}
	
	/**
	 * After an new node is added the current node must be set onto the
	 * new, the next sibling.
	 *
	 */
	private function procedeNext(){
		$this->currentNode=$this->currentNode->nextSibling;
	}
	
	/**
	 * Insert an $newNode after an $oldNode in the
	 * $dom structure.
	 *
	 * @param DOMDocument $dom DOM Structure
	 * @param DOMNode $oldNode Node after witch should be inserted
	 * @param DOMNode $newNode Node to be inserted
	 * @return The node inserted
	 */
	public static function insertAfter(DOMDocument $dom, DOMNode $oldNode, DOMNode $newNode){
	    if ($oldNode->nextSibling != null){
		    // There are more children after the node after which should be inserted
		    return $oldNode->nextSibling->insertBefore($newNode,$oldNode->nextSibling);
		} else {
		    // The node after witch should be inserted is the last child
		    return $oldNode->parentNode->appendChild($newNode);
		}
	}
	
	public function addTable(array $tableData,$withHeader){
	    if (!$this->checkTableData($tableData)){
	        throw new Exception("The rows in tableData don't have the same number of columns");
	    }
	    //require_once('odfNodes/Table.class.php');
	    //require_once('odfNodes/TableRow.class.php');
	    //require_once('odfNodes/TableCell.class.php');
	    $numOfCols = count($tableData[0]);
	    $numOfRows = count($tableData);
	    $table = new Table($this->dom,$numOfCols);
	    $tableNode = $table->addTable($this->currentNode);
	    $this->currentNode = $tableNode;
	    for ($i=0;$i<$numOfRows;$i++){
	        $tableRow = new TableRow($this->dom);
	        $row = $tableData[$i];
			$tableRowNode;
	        if ($i==0 && $withHeader){
	            $tableRowNode = $tableRow->addTableHeaderRow($tableNode);
	        } else {
	            $tableRowNode = $tableRow->addTableRow($tableNode);
	        }
	        $this->currentNode = $tableRowNode;
	        for ($j=0;$j<$numOfCols;$j++){
	            $cell = $row[$j];
	            $tableCell = new TableCell($this->dom);
	            $this->currentNode = $tableCell->addTableCell($tableRowNode,'string',$cell);
	            if ($j==$numOfCols-1){
	                // Last cell => step out
	                $this->currentNode=$this->currentNode->parentNode;
	            }
	        }
	        if ($j==$numOfRows-1){
                // Last row => step out
                $this->currentNode=$this->currentNode->parentNode;
            } else {
                $this->procedeNext();
            }
   	    }
	}
	
	/**
	 * Check if each row in $tableData has the
	 * same number of columns.
	 * @param array $tableData array containing the rows of a
	 * table as arrays
	 * @return true if the $tableData array is well formed, else
	 * false;
	 */
	private function checkTableData(array $tableData){
	    $numOfCols=count($tableData[0]);
	    foreach($tableData as $row){
	        if (count($row)!=$numOfCols){
	            print_r($row);
	           return false; 
	       }
	    }
	    return true;
	}
	
	/**
	 * Gets the name and value of the current node
	 *
	 * @return string with the node name and its value.
	 */
	private function getCurrentNode(){
	    return "nodeName: ".$this->currentNode->nodeName.", nodeValue: ".$this->currentNode->nodeValue;
	}
	
	/**
	 * Converts the DOM structure into a string
	 * that can be written to a file by the IO class
	 * @return string representation of the DOM structure.
	 */
	public function toString(){
	    return $this->dom->saveXML();
	}
	
}
?><?php

/**
 * This class handles the adding of styled and unstyled
 * Header (text strings) in the DOM structure.
 *  
 * $Id: Heading.class.php,v 1.1.1.1 2006/09/17 15:41:38 Andi Exp $
 *
 * @license    http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @copyright  Copyright in 2006 by Andi Hotz
 * @copyright  GNU Lesser General Public License
 * @author     Andi Hotz
 * @version    $Revision: 1.1.1.1 $
 * @package    ODFLib
 * @subpackage odfNodes
 * @since      0.0.1
 */
class Heading{
	
	private $dom;
	
	public function __construct(DOMDocument $dom){
		$this->dom=$dom;
	}
	/**
	 * Add a new paragraph with the paragraph $text
	 * after $afterNode
	 * @param string $text paragraph text
	 * @param int $outlineLevel level of the Heading
	 * @param DOMNode $afterNode After this node the paragraph
	 * is added in the DOM structure
	 * @return The inserted node
	 */
	public function addHeading($text,$outlineLevel = 1,DOMNode $afterNode){
		if (empty ($text)) {
			$head = $this->dom->createElement('text:h');
		} else {
			$head = $this->dom->createElement('text:h', $text);
		}
		$head->setAttribute('text:outline-level', $outlineLevel);
		//require_once('Replace.class.php');
		return Replace::insertAfter($this->dom,$afterNode,$head);
		
	}
	
	/**
	 * Add a new paragraph with the paragraph $text
	 * after $afterNode. A style is spezialized
	 * @param string $text paragraph text
	 * @param int $outlineLevel level of the Heading
	 * @param DOMNode $afterNode After this node the paragraph
	 * is added in the DOM structure
	 * @param string $style of the paragraph.
	 * @return The inserted node
	 */
	public function addStyledHeading($text,$outlineLevel = 1,DOMNode $afterNode,$style){
		if (empty ($text)) {
			$head = $this->dom->createElement('text:p');
		} else {
			$head = $this->dom->createElement('text:p', $text);
		}
		$head->setAttribute('text:outline-level', $outlineLevel);
		$head->setAttribute('text:style-name', $style);
		//require_once('Replace.class.php');
		return Replace::insertAfter($this->dom,$afterNode,$head);
		
	}
	
}
?><?php

/**
 * This class handles the adding of styled and unstyled
 * paragraphs (text strings) in the DOM structure.
 *  
 * $Id: Paragraph.class.php,v 1.1.1.1 2006/09/17 15:41:38 Andi Exp $
 *
 * @license    http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @copyright  Copyright in 2006 by Andi Hotz
 * @copyright  GNU Lesser General Public License
 * @author     Andi Hotz
 * @version    $Revision: 1.1.1.1 $
 * @package    ODFLib
 * @subpackage odfNodes
 * @since      0.0.1
 */
class Paragraph{

	
	/**
	 * DOMDocument
	 */
	private $dom;
	
	/**
	 * Initialise the DOMDocument
	 *
	 * @param DOMDocument $dom
	 */
	public function __construct(DOMDocument $dom){
		$this->dom=$dom;
	}
	
	/**
	 * Add a new paragraph with the paragraph $text
	 * after $afterNode
	 * @param string $text paragraph text
	 * @param DOMNode $afterNode After this node the paragraph
	 * is added in the DOM structure
	 * @return The inserted node
	 */
	public function addParagraph($text,DOMNode $afterNode){
		if (empty ($text)) {
			$par = $this->dom->createElement('text:p');
		} else {
			$par = $this->dom->createElement('text:p', $text);
		}
		//require_once('Replace.class.php');
		return Replace::insertAfter($this->dom,$afterNode,$par);
	}
	
	/**
	 * Add a new paragraph with the paragraph $text
	 * after $afterNode. A style is spezialized
	 * @param string $text paragraph text
	 * @param DOMNode $afterNode After this node the paragraph
	 * is added in the DOM structure
	 * @param string $style of the paragraph.
	 * @return The inserted node
	 */
	public function addStyledParagraph($text,DOMNode $afterNode,$style){
		if (empty ($text)) {
			$par = $this->dom->createElement('text:p');
		} else {
			$par = $this->dom->createElement('text:p', $text);
		}
		$par->setAttribute('text:style-name', $style);
		//require_once('Replace.class.php');
		return Replace::insertAfter($this->dom,$afterNode,$par);
	}
}
?><?php

/**
 * This class handles the adding of styled and unstyled
 * tables in the DOM structure. A Table must then be filled with
 * TableRows
 *  
 * $Id: Table.class.php,v 1.1.1.1 2006/09/17 15:41:38 Andi Exp $
 *
 * @license    http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @copyright  Copyright in 2006 by Andi Hotz
 * @copyright  GNU Lesser General Public License
 * @author     Andi Hotz
 * @version    $Revision: 1.1.1.1 $
 * @package    ODFLib
 * @subpackage odfNodes
 * @since      0.0.1
 */
class Table{
	/**
	 * DOMDocument
	 */
	private $dom;
	
	/**
	 * Name of the table
	 */
	private $tableName;
	
	/**
	 * Number of Columns
	 */
	private $numOfCols;
	
	/**
	 * Initialise the DOMDocument.
	 * The table name is initialised with a timestamp
	 * @param DOMDocument $dom
	 */
	public function __construct(DOMDocument $dom, $numOfCols = 1){
		$this->dom=$dom;
		$this->tableName="Table".time();
		$this->numOfCols=$numOfCols;
	}
	
	/**
	 * Add a new table node to the DOM structure
	 *
	 * @param DOMNode $afterNode table is appended after
	 * @return the new table node
	 * 	 */
	public function addTable(DOMNode $afterNode){
		$table = $this->dom->createElement('table:table');
		$colDef = $this->dom->createElement('table:table-column');
		$colDef->setAttribute('table:number-columns-repeated',$this->numOfCols);
		$table->appendChild($colDef);
		//require_once('Replace.class.php');
		return Replace::insertAfter($this->dom,$afterNode,$table);
	}

	/**
	 * Add a new table node to the DOM structure
	 *
	 * @param DOMNode $afterNode table is appended after
	 * @param string $style of the table
	 * @return the new table node
	 */
	public function addStyledTable(DOMNode $afterNode,$style){
		$table = $this->dom->createElement('table:table');
		$table->setAttribute('table:style-name', $style);
		$colDef = $this->dom->createElement('table:table-column');
		$colDef->setAttribute('table:number-columns-repeated',$this->numOfCols);
		$table->appendChild($colDef);
		//require_once('Replace.class.php');
		return Replace::insertAfter($this->dom,$afterNode,$table);
	}
	
}
?><?php

/**
 * This class handles the adding 
 * tablecells in the DOM structure.
 *  
 * $Id: TableCell.class.php,v 1.1.1.1 2006/09/17 15:41:38 Andi Exp $
 *
 * @license    http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @copyright  Copyright in 2006 by Andi Hotz
 * @copyright  GNU Lesser General Public License
 * @author     Andi Hotz
 * @version    $Revision: 1.1.1.1 $
 * @package    ODFLib
 * @subpackage odfNodes
 * @since      0.0.1
 */
class TableCell{
	/**
	 * DOMDocument
	 */
	private $dom;
	
	/**
	 * Initialise the DOMDocument.
	 * @param DOMDocument $dom
	 */
	public function __construct(DOMDocument $dom){
		$this->dom=$dom;
	}

	/**
	 * Add a new table cell
	 * after $afterNode
	 * @param DOMNode $rowNode parent node (row-node) where
	 * the new node is added in the DOM structure as last child
	 * @param string $dataType datatype of the cell contents
	 * @param string $text content of the cell
	 * @return the new table node
	 */
	public function addTableCell(DOMNode $rowNode, $dataType='string', $text=''){
		$cell = $this->dom->createElement('table:table-cell');
		$cell->setAttribute('office:value-type',$dataType);
		$inner = $this->dom->createelement('text:p',$text);
		$cell->appendChild($inner);
		$rowNode->appendChild($cell);
	}

	/**
	 * Add a new table cell
	 * after $afterNode
	 * @param DOMNode $rowNode parent node (row-node) where
	 * the new node is added in the DOM structure as last child
	 * @param string $dataType datatype of the cell contents
	 * @param string $text content of the cell
	 * @return the new table node
	 */
	public function addStyledTableCell(DOMNode $rowNode, $dataType='string', $text='',$cellStyle,$textStyle){
		$cell = $this->dom->createElement('table:table-cell');
		$cell->setAttribute('office:value-type',$dataType);
		$cell->setAttribute('table:style-name', $cellStyle);
		$inner = $this->dom->createelement('text:p',$text);
		$inner->setAttribute('text:style-name', $textStyle);
		$cell->appendChild($inner);
		$rowNode->appendChild($cell);
	}
	
}
?><?php

/**
 * This class handles the adding 
 * tablerows in the DOM structure. A TableRow must then be filled with
 * TableCells
 *  
 * $Id: TableRow.class.php,v 1.1.1.1 2006/09/17 15:41:38 Andi Exp $
 *
 * @license    http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @copyright  Copyright in 2006 by Andi Hotz
 * @copyright  GNU Lesser General Public License
 * @author     Andi Hotz
 * @version    $Revision: 1.1.1.1 $
 * @package    ODFLib
 * @subpackage odfNodes
 * @since      0.0.1
 */
class TableRow{
	/**
	 * DOMDocument
	 */
	private $dom;
	
	/**
	 * Initialise the DOMDocument.
	 * @param DOMDocument $dom
	 */
	public function __construct(DOMDocument $dom){
		$this->dom=$dom;
	}

	/**
	 * Add a new table row
	 * after $afterNode
	 * @param DOMNode $tableNode The parent node (table-node) in the
	 * the DOM structure
	 * @return the new table node
	 */
	public function addTableRow(DOMNode $tableNode){
		$par = $this->dom->createElement('table:table-row');
		//require_once('Replace.class.php');
		return $tableNode->appendChild($par);
	}

	/**
	 * Add a new table header row 
	 * after $afterNode
	 * @param DOMNode $tableNode After this node the paragraph
	 * is added in the DOM structure
	 * @return the new table node
	 */
	public function addTableHeaderRow(DOMNode $tableNode){
		$par = $this->dom->createElement('table:table-header-rows');
		$inner = $this->dom->createelement('table:table-row');
		$par->appendChild($inner);
		//require_once('Replace.class.php');
		return $tableNode->appendChild($par);
	}
	
}
?>